using System;
using System.Configuration;
using System.Runtime.Serialization;
using System.Security.Permissions;

namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/19/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	///		This exception is thrown whenever primary key or unique index constraint is violated in the DB. 
	/// </summary>

	#endregion

	[Serializable]
	public class UniqueDatabaseConstraintViolatedException : DataAccessLayerException
	{
		private string _conflictingDbColumnName;

		private void SetInitialParams()
		{
			_conflictingDbColumnName = null;
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/19/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6408"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Object is constructed, no exception is thrown.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6409"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>Initializes a new instance of the class.</summary>
		public UniqueDatabaseConstraintViolatedException() : base() 
		{
			SetInitialParams();
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/19/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6406"> 
		///		<ExpectedInput>String message.</ExpectedInput>
		///		<ExpectedOutput>Object is created, no exception is thrown, message is set.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6407"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>Initializes a new instance of the class with a specified error message.</summary>
		///<param name="message">The message that describes the error. </param>
		public UniqueDatabaseConstraintViolatedException( string message ) : base( message ) 
		{
			SetInitialParams();
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/19/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6404"> 
		///		<ExpectedInput>Test error message and test exception.</ExpectedInput>
		///		<ExpectedOutput>Object is created, no exception is thrown, error message and inner exception are set.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6405"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		///	Initializes a new instance of the class with a specified error message and a reference 
		///	to the inner exception that is the cause of this exception.
		///	</summary>
		///<param name="message">The error message that explains the reason for the exception. </param>
		///<param name="inner">The exception that is the cause of the current exception. </param>
		public UniqueDatabaseConstraintViolatedException( string message, Exception inner ) : base( message, inner ) 
		{
			SetInitialParams();
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/19/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6412"> 
		///		<ExpectedInput>Test DB column name.</ExpectedInput>
		///		<ExpectedOutput>Matching DB column name.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6915"> 
		///		<ExpectedInput>Freshly created object.</ExpectedInput>
		///		<ExpectedOutput>Conflicting DB column name is null.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6413"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>Conflicting table column name.</summary>
		public string ConflictingDbColumnName
		{
			get
			{
				return _conflictingDbColumnName;
			}
			set
			{
				_conflictingDbColumnName = value;
			}
		}
	}
}
